/*
 * Decompiled with CFR 0.152.
 */
package io.github.fabricators_of_create.porting_lib.resource;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.minecraft.class_2960;
import net.minecraft.class_3255;
import net.minecraft.class_3262;
import net.minecraft.class_3264;
import net.minecraft.class_3270;
import net.minecraft.class_3272;
import net.minecraft.class_7367;
import org.jetbrains.annotations.Nullable;

public class DelegatingPackResources
extends class_3255 {
    private final class_3272 packMeta;
    private final List<class_3262> delegates;
    private final Map<String, List<class_3262>> namespacesAssets;
    private final Map<String, List<class_3262>> namespacesData;

    public DelegatingPackResources(String packId, boolean isBuiltin, class_3272 packMeta, List<? extends class_3262> packs) {
        super(packId, isBuiltin);
        this.packMeta = packMeta;
        this.delegates = ImmutableList.copyOf(packs);
        this.namespacesAssets = this.buildNamespaceMap(class_3264.field_14188, this.delegates);
        this.namespacesData = this.buildNamespaceMap(class_3264.field_14190, this.delegates);
    }

    private Map<String, List<class_3262>> buildNamespaceMap(class_3264 type, List<class_3262> packList) {
        HashMap<String, List> map = new HashMap<String, List>();
        for (class_3262 pack : packList) {
            for (String namespace : pack.method_14406(type)) {
                map.computeIfAbsent(namespace, k -> new ArrayList()).add(pack);
            }
        }
        map.replaceAll((k, list) -> ImmutableList.copyOf((Collection)list));
        return ImmutableMap.copyOf(map);
    }

    @Nullable
    public <T> T method_14407(class_3270<T> deserializer) throws IOException {
        return (T)(deserializer.method_14420().equals("pack") ? this.packMeta : null);
    }

    public void method_14408(class_3264 type, String resourceNamespace, String paths, class_3262.class_7664 resourceOutput) {
        for (class_3262 delegate : this.delegates) {
            delegate.method_14408(type, resourceNamespace, paths, resourceOutput);
        }
    }

    public Set<String> method_14406(class_3264 type) {
        return type == class_3264.field_14188 ? this.namespacesAssets.keySet() : this.namespacesData.keySet();
    }

    public void close() {
        for (class_3262 pack : this.delegates) {
            pack.close();
        }
    }

    @Nullable
    public class_7367<InputStream> method_14410(String ... paths) {
        return null;
    }

    @Nullable
    public class_7367<InputStream> method_14405(class_3264 type, class_2960 location) {
        for (class_3262 pack : this.getCandidatePacks(type, location)) {
            class_7367 ioSupplier = pack.method_14405(type, location);
            if (ioSupplier == null) continue;
            return pack.method_14405(type, location);
        }
        return null;
    }

    @Nullable
    public Collection<class_3262> getChildren() {
        return this.delegates;
    }

    private List<class_3262> getCandidatePacks(class_3264 type, class_2960 location) {
        Map<String, List<class_3262>> map = type == class_3264.field_14188 ? this.namespacesAssets : this.namespacesData;
        List<class_3262> packsWithNamespace = map.get(location.method_12836());
        return packsWithNamespace == null ? Collections.emptyList() : packsWithNamespace;
    }
}

